/*
 *
 * w4 - budget.js
 * version 2.0
 *
 *
 */


	// dichiaro le variabili globali visibili in tutte le funzioni
	var elenco_budget=[];
	var tabella_elenco;
	var elenco_indice = -1;


	var elenco_budget_c=[];
	var tabella_elenco_c;
	var elenco_indice_c = -1;

	var elenco_budget_c_1=[];
	var tabella_elenco_c_1;
	var elenco_indice_c_1 = -1;


	var elenco_budget_c_prev=[];
	var tabella_elenco_c_prev;
	var elenco_indice_c_prev = -1;


	$(function() {
	  
		//**************************************
		// Inizializza all'apertura della pagina
		//**************************************
		
		
		

		// Imposta quale menu deve essere attivo nell'indice di sx
	  	$("#index_scuola24_budget").addClass("active");
		$("#side-menu").metisMenu();
		
		$("#id-hide-menu").click();
		
	
	  
        // Inizializza i dati ed valorizza i default
        $("#id_inizializza").init(function(){
//			w4_budget_elenco();
        });
	  
	  
        $("#id_filtro_anno").select2({
			data: w4_combo_anno()
		});
		
		$("#id_filtro_anno").select2().val("<?php echo date('Y'); ?>").trigger("change");
		
		
		
		$("#id_filtro_c_iniziativa").select2({
			ajax: {
				url: "/w4/scuola24/lib_sql/comboremote/comboremote_iniziativa.php?w4_sessione=<?php echo $_SESSION['w4_sessione']; ?>",
				dataType: 'json',
				delay: 250,
				data: function (params) {
					return {
						search: params.term,
					};
				},
				processResults: function (data) {
					return  {
						results: data,
					};
				},
			},
			minimumInputLength: 3,
			minimumResultsForSearch: -1
		});
		
		
		$("#id_filtro_categoria").select2({
			data: w4_combo_categoria_prod()
		});
		$("#id_filtro_categoria").select2().val("").trigger("change");
		
		
		$("#id_filtro_categoria").on("change", function() {
		   $("#id_filtro_gruppo").html("");
		   $("#id_filtro_gruppo").select2({
			   data: w4_combo_gruppo_prod()
		   });
		   $("#id_filtro_gruppo").select2().val("").trigger("change");

	    });

		$("#id_filtro_gruppo").select2({
			data: w4_combo_gruppo_prod()
		});
		$("#id_filtro_gruppo").select2().val("").trigger("change");
		
		
		$("#id_filtro_cerca").on("click", function() {
		
			w4_budget_elenco();
			
		});
		
	

		
		// Inizializza la tabella elenco budget
      	tabella_elenco = $("#id_budget_elenco").dataTable( {
			data: elenco_budget,
			dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>tp",
			paging: false,
			columns: [
					{ data: 'c_iniziativa', sClass:"text-left all" },
					{ data: 'titolo', sClass:"text-left all"},
					{ data: 'lav_prezzo', sClass:"text-right all", 'orderable': false  },
					
					{ data: 'lav_perc_sconto_medio', sClass:"text-right all", 'orderable': false  },
					{ data: 'lav_n_iscrizioni_ip', sClass:"text-right all", 'orderable': false  },
					{ data: 'lav_imp_netto', sClass:"text-right all", 'orderable': false  },
					
					{ data: 'bud_perc_sconto_medio', sClass:"text-right all", 'orderable': false  },
					{ data: 'bud_numero_iscritti', sClass:"text-right all", 'orderable': false  },
					{ data: 'bud_ricavi', sClass:"text-right all", 'orderable': false  },
					
					{ data: 'prev_listino', sClass:"text-right all", width: "9%", 'orderable': false  },
					{ data: 'prev_perc_sconto_medio', sClass:"text-right all", width: "6%", 'orderable': false  },
					{ data: 'prev_numero_iscritti', sClass:"text-right all", width: "6%", 'orderable': false  },
					{ data: 'prev_ricavi', sClass:"text-right all", 'orderable': false  },
					
					{ data: 'comp_lavagna', sClass:"text-right all", 'orderable': false  },
					{ data: 'comp_previsionale', sClass:"text-right all", 'orderable': false  },
					{ data: 'comp_budget', sClass:"text-right all", 'orderable': false  }
			],
			select: false,
			rowCallback: function( row, data ) {
			
				$c_iniziativa=data.n_budget;
				if (data.c_iniziativa!='')
					$c_iniziativa=data.c_iniziativa;
					
				$stato_iniziativa='';
				switch (data.stato_iniziativa) {
                    case "I":
                        $stato_iniziativa="<i class='fa fa-battery-1 text-info' title='Ideazione'> </i>";
                        break;
                    case "C":
                        $stato_iniziativa="<i class='fa fa fa-battery-4 text-success' title='Confermato'> </i>";
                        break;
                    case "A":
                        $stato_iniziativa="<i class='fa fa-battery-4 text-danger' title='Annullato'> </i>";
                        break;
                    case "P":
                        $stato_iniziativa="<i class='fa fa-battery-1 text-warning' title='Posticipato'>";
                        break;
                    default:
                        break;
                }			
				
				$('td:eq(0)', row).html("<a><i class=\"fa fa-search-plus\"></i> "+$c_iniziativa+"</a>"+"<br>"+$stato_iniziativa);
				$('td:eq(1)', row).html(data.titolo);
				$('td:eq(2)', row).html(parseFloat(data.lav_prezzo).toLocaleString());

				// lavagna
				$('td:eq(4)', row).html(parseInt(data.lav_n_iscrizioni_ip)+parseInt(data.lav_n_iscrizioni_mod));
				$('td:eq(5)', row).html("<a>"+parseFloat(data.lav_imp_netto).toLocaleString()+" <i class=\"fa fa-search-plus\"></i> </a>");
			
				// budget/forecast
				$('td:eq(7)', row).html(parseInt(data.numero_iscritti));
				$('td:eq(8)', row).html(parseFloat(data.bud_ricavi).toLocaleString());

				// previsionale
				if (data.aperto=='1') {
					// previsionale aperto
					$('td:eq(9)', row).html('<input type="text" class="form-control id_prev_listino"  id ="id_prev_listino_'+row._DT_RowIndex+'" value="'+data.prev_listino+'" style="width: 95%; text-align:right">');
					$('td:eq(10)', row).html('<input type="text" class="form-control id_prev_perc_sconto_medio" id ="id_prev_perc_sconto_medio_'+row._DT_RowIndex+'" value="'+data.prev_perc_sconto_medio+'" style="width: 70%; text-align:right">');
					$('td:eq(11)', row).html('<input type="text" class="form-control id_prev_numero_iscritti"  id ="id_prev_numero_iscritti_'+row._DT_RowIndex+'" value="'+data.prev_numero_iscritti+'" style="width: 70%; text-align:right">');
				}
				else {
					// previsionale chiuso
					$('td:eq(9)', row).html(parseFloat(data.prev_listino).toLocaleString());
					$('td:eq(10)', row).html(parseFloat(data.prev_perc_sconto_medio).toLocaleString());
					$('td:eq(11)', row).html(parseFloat(data.prev_numero_iscritti).toLocaleString());
				}
				
				$('td:eq(12)', row).html(parseFloat(data.prev_ricavi).toLocaleString());
								
				$('td:eq(13)', row).html(parseFloat(data.comp_lavagna).toLocaleString());
				$('td:eq(14)', row).html("<a>"+parseFloat(data.comp_previsionale).toLocaleString()+" <i class=\"fa fa-search-plus\"></i> </a>");
				$('td:eq(15)', row).html(parseFloat(data.comp_budget).toLocaleString());
			},
			drawCallback: function() {
				setTimeout(w4_eventi_tabella, 100);
			},
			responsive: {
				details: {
					display: $.fn.dataTable.Responsive.display.modal()
				}
			},
			language: {
				url: "/vendor/datatables/media/lang/italian.json"
			}
		});
		
		
		$("#id_budget_elenco tbody").on('click', 'td', function () {
			elenco_indice = this._DT_CellIndex.row;
			
			// Modal Iniziativa
			if (this._DT_CellIndex.column=='0') {
				$("#id_budget_elenco_c").removeClass("dataTable");
				
				$("#id_budget_c_titolo").html(elenco_budget[elenco_indice].titolo);
				$("#id_budget_c_categoria").html(elenco_budget[elenco_indice].c_prod_linea_des);
				$("#id_budget_c_gruppo").html(elenco_budget[elenco_indice].c_prod_gruppo_des);
				$("#id_budget_c_area_tematica").html(elenco_budget[elenco_indice].area_tematica_des);
				$("#id_budget_c_decorrenza").html(elenco_budget[elenco_indice].data_inizio_prevista+" - "+elenco_budget[elenco_indice].data_fine_prevista+" <b>Mese Competenza</b> "+elenco_budget[elenco_indice].mese_comp);
				
				$("#id_budget_c_responsabile_r").html(elenco_budget[elenco_indice].responsabile_redazione);
				$("#id_budget_c_responsabile_p").html(elenco_budget[elenco_indice].responsabile_progetto);
				$("#id_budget_c_responsabile_m").html(elenco_budget[elenco_indice].responsabile_marketing);
				
				elenco_budget_c=[];
				tabella_elenco_c.fnClearTable();
				
				if (elenco_budget[elenco_indice].tmp_budget_c.length > 0) {
					elenco_budget_c = $.extend(true,{},elenco_budget[elenco_indice].tmp_budget_c);
					
					tabella_elenco_c.fnClearTable();
					
					for ( indice in elenco_budget_c ) {
						tabella_elenco_c.fnAddData(elenco_budget_c[indice],false);
					}
					tabella_elenco_c.fnDraw();
				}
					
				$("#id_budget_c_modal").modal("show");
			}
			
			// Modal Billing
			if (this._DT_CellIndex.column=='5') {
				$("#id_budget_elenco_c_1").removeClass("dataTable");
				$("#id_budget_c_titolo_1").html(elenco_budget[elenco_indice].titolo);
				
				elenco_budget_c_1=[];
				tabella_elenco_c_1.fnClearTable();
				
				if (elenco_budget[elenco_indice].tmp_budget_c.length > 0) {
					elenco_budget_c_1 = $.extend(true,{},elenco_budget[elenco_indice].tmp_budget_c);
					
					tabella_elenco_c_1.fnClearTable();
					
					for ( indice in elenco_budget_c_1 ) {
						tabella_elenco_c_1.fnAddData(elenco_budget_c_1[indice],false);
					}
					tabella_elenco_c_1.fnDraw();
				}
					
				$("#id_budget_c_modal_1").modal("show");
			}
			
			// Modal Competenze / Previsionale
			if (this._DT_CellIndex.column=='14') {
				$("#id_budget_elenco_c_prev").removeClass("dataTable");
				$("#id_budget_c_titolo_prev").html(elenco_budget[elenco_indice].titolo);
				
				elenco_budget_c_prev=[];
				tabella_elenco_c_prev.fnClearTable();
				
				if (elenco_budget[elenco_indice].tmp_prevr_comp.length > 0) {
					elenco_budget_c_prev = $.extend(true,{},elenco_budget[elenco_indice].tmp_prevr_comp);
					
					tabella_elenco_c_prev.fnClearTable();
					
					for ( indice in elenco_budget_c_prev ) {
						tabella_elenco_c_prev.fnAddData(elenco_budget_c_prev[indice],false);
					}
					tabella_elenco_c_prev.fnDraw();
				}
					
				$("#id_budget_c_modal_prev").modal("show");
			}
		});
		
		$("#id_prev_conferma").click(function(){
		   swal({
				title: "Sei sicuro?",
				text: "Conferma per memorizzare, oppure annulla.",
				showCancelButton: true,
				focusCancel: true,
				confirmButtonColor: "#62cb31",
				confirmButtonText: "Si, confermo!",
				cancelButtonText: "No, annullo",
				
			}).then(function() {
				if (w4_updbudget_prev()) {
					swal("Fatto!", "Dati memorizzati.", "success");
				}
				else
				{
					swal("Errore!", "Memorizzazione fallita", "error");
				}
			
			}, function (dismiss) {});
		});
		

		// Modal iniziativa
		tabella_elenco_c = $("#id_budget_elenco_c").dataTable( {
			data: elenco_budget_c,
			dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>tp",
			lengthMenu: [ [5,10,20, 50, 100], [5,10,20, 50, 100] ],
			columns: [
					{ data: 'c_conv', sClass:"text-left" },
					{ data: 'descrizione', sClass:"text-left" },
					{ data: 'data_conv_da', sClass:"text-center" },
					{ data: 'data_conv_a', sClass:"text-center" },
					{ data: 'mesi_totali', sClass:"text-center" },
					  
					{ data: 'prezzo_listino_ip', sClass:"text-right" },
					{ data: 'prezzo_listino_mod', sClass:"text-right" }
			],
			select: false,
			rowCallback: function( row, data ) {
				$('td:eq(4)', row).html(data.mesi_totali+"/"+data.mesi_anno);
				$('td:eq(5)', row).html(parseFloat(data.prezzo_listino_ip).toLocaleString());
				$('td:eq(6)', row).html(parseFloat(data.prezzo_listino_mod).toLocaleString());
			},			
			
			responsive: {
				details: {
					display: $.fn.dataTable.Responsive.display.modal()
				}
			},
			language: {
				url: "/vendor/datatables/media/lang/italian.json"
			}
		});
		
		
		// Modal Billing
      	tabella_elenco_c_1 = $("#id_budget_elenco_c_1").dataTable( {
			data: elenco_budget_c_1,
			dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>tp",
			lengthMenu: [ [5,10,20, 50, 100], [5,10,20, 50, 100] ],
			columns: [
					{ data: 'c_conv', sClass:"text-left" },
					{ data: 'descrizione', sClass:"text-left" },
					{ data: 'data_conv_da', sClass:"text-left" },
					{ data: 'mesi_totali', sClass:"text-center" },
					
					{ data: 'prezzo_listino_ip', sClass:"text-right" },
					{ data: 'prezzo_listino_mod', sClass:"text-right" },

					{ data: 'n_iscrizioni_ip', sClass:"text-left" },
					{ data: 'n_iscrizioni_mod', sClass:"text-left" },
					
					{ data: 'imp_ordinato_ip', sClass:"text-right" },
					{ data: 'imp_ordinato_mod', sClass:"text-right" },
					
					{ data: 'perc_sconto_medio_ip', sClass:"text-right", width: "5%" },
					{ data: 'perc_sconto_medio_mod', sClass:"text-right", width: "5%" },
					
					{ data: 'imp_note_credito', sClass:"text-right" },
					{ data: 'imp_netto', sClass:"text-right" }
			],
			select: false,
			rowCallback: function( row, data ){
				$('td:eq(2)', row).html(data.data_conv_da+"<br>"+data.data_conv_a);
				$('td:eq(3)', row).html(data.mesi_totali+"/"+data.mesi_anno);

				$('td:eq(4)', row).html(parseFloat(data.prezzo_listino_ip).toLocaleString());
				$('td:eq(5)', row).html(parseFloat(data.prezzo_listino_mod).toLocaleString());

				$('td:eq(8)', row).html(parseFloat(data.imp_ordinato_ip).toLocaleString());
				$('td:eq(9)', row).html(parseFloat(data.imp_ordinato_mod).toLocaleString());
				
				if (parseFloat(data.perc_sconto_medio_ip)>0)
					$('td:eq(10)', row).html(parseFloat(data.imp_sconto_ip).toLocaleString()+"<br>"+data.perc_sconto_medio_ip+"%");
				else
					$('td:eq(10)', row).html(parseFloat(data.imp_sconto_ip).toLocaleString());
					
				if (parseFloat(data.perc_sconto_medio_mod)>0)
					$('td:eq(11)', row).html(parseFloat(data.imp_sconto_mod).toLocaleString()+"<br>"+data.perc_sconto_medio_mod+"%");
				else
					$('td:eq(11)', row).html(parseFloat(data.imp_sconto_mod).toLocaleString());

				$('td:eq(12)', row).html(parseFloat(data.imp_note_credito).toLocaleString());
				$('td:eq(13)', row).html(parseFloat(data.imp_netto).toLocaleString());
			},
			responsive: {
				details: {
					display: $.fn.dataTable.Responsive.display.modal()
				}
			},
			language: {
				url: "/vendor/datatables/media/lang/italian.json"
			}
		});
		
		
		
		// Modal Competenze / Previsionale		
		tabella_elenco_c_prev = $("#id_budget_elenco_c_prev").dataTable( {
			data: elenco_budget_c_prev,
			dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>tp",
			lengthMenu: [ [12], [12] ],
			columns: [
					{ data: 'anno', sClass:"text-left" },
					{ data: 'mese', sClass:"text-left" },
					{ data: 'ricavi_l', sClass:"text-right" },
					{ data: 'ricavi_p', sClass:"text-right" },
					{ data: 'ricavi_b', sClass:"text-right" }
					
			],
			select: false,
			rowCallback: function( row, data ){
			
				$des_mese="";
				switch (data.mese) {
					case "1":	$des_mese="Gennaio";	break;
					case "2":	$des_mese="Febbraio";	break;
					case "3":	$des_mese="Marzo";		break;
					case "4":	$des_mese="Aprile";		break;
					case "5":	$des_mese="Maggio";		break;
					case "6":	$des_mese="Giugno";		break;
					case "7":	$des_mese="Luglio";		break;
					case "8":	$des_mese="Agosto";		break;
					case "9":	$des_mese="Settembre";	break;
					case "10":	$des_mese="Ottobre";	break;
					case "11":	$des_mese="Novembre";	break;
					case "12":	$des_mese="Dicembre";	break;
					default: break;
				}
				$('td:eq(1)', row).html($des_mese);
				$('td:eq(2)', row).html(parseFloat(data.ricavi_l).toLocaleString());
				$('td:eq(3)', row).html(parseFloat(data.ricavi_p).toLocaleString());
				$('td:eq(4)', row).html(parseFloat(data.ricavi_b).toLocaleString());
				
					
			},
			responsive: {
				details: {
					display: $.fn.dataTable.Responsive.display.modal()
				}
			},
			language: {
				url: "/vendor/datatables/media/lang/italian.json"
			}
		});


		// -------------------------
		// CALCOLA BUDGET
		// -------------------------
		$("#id_pannello_budget_calcola").on("click", function () {
			$("#id_filtro_calc_anno").html(document.getElementById("id_filtro_anno").value);

			$("#id_filtro_calc_c_iniziativa_des").html("");
			if (document.getElementById("id_filtro_c_iniziativa").value!="") {
				var combo = document.getElementById("id_filtro_c_iniziativa");
				var descrizione = combo.options[combo.selectedIndex].text;

				$("#id_filtro_calc_c_iniziativa_des").html(descrizione);
			}

			$("#id_filtro_calc_categoria_des").html("");
			if (document.getElementById("id_filtro_categoria").value!="") {
				var combo = document.getElementById("id_filtro_categoria");
				var descrizione = combo.options[combo.selectedIndex].text;

				$("#id_filtro_calc_categoria_des").html(descrizione);
			}

			$("#id_filtro_calc_gruppo_des").html("");
			if (document.getElementById("id_filtro_gruppo").value!="") {
				var combo = document.getElementById("id_filtro_gruppo");
				var descrizione = combo.options[combo.selectedIndex].text;

				$("#id_filtro_calc_gruppo_des").html(descrizione);
			}
	    });

		$("#id_filtro_calc_calcola").click(function(){
			swal({
				title: "Vuoi continuare?",
				text:  "Una notifica verrà inviata appena il calcolo budget sarà concluso.",
				showCancelButton: true,
				confirmButtonColor: "#62cb31",
				confirmButtonText: "Continua",
				cancelButtonText: "Annulla",
				}).then(function() {
					$.ajax({
						url: "/w4/scuola24/lib_sql/updrow/calcolabudget.php?w4_sessione=<?php echo $_SESSION['w4_sessione']; ?>",
						type: 'POST',
						datatype:'text',
						data: {
							id_filtro_calcola: "S",
							id_filtro_anno: document.getElementById("id_filtro_anno").value,
							id_filtro_c_iniziativa: document.getElementById("id_filtro_c_iniziativa").value,
							id_filtro_categoria: document.getElementById("id_filtro_categoria").value,
							id_filtro_gruppo: document.getElementById("id_filtro_gruppo").value,

							w4_output_session: JSON.stringify(<?php echo json_encode(session_encode(), JSON_HEX_QUOT | JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_FORCE_OBJECT | JSON_UNESCAPED_UNICODE | JSON_PARTIAL_OUTPUT_ON_ERROR); ?>),
							w4_mysql_limit_new: document.getElementById("id_mysql_limit").value
						},
						success: function(data) {
							text = data;
							w4_index_notifiche();
							return true;
						}
					});

			}, function (dismiss) {});
		});


		$("#id_filtro_calc_cancella").click(function(){
		  swal({
			  title: "Vuoi continuare?",
			  text:  "Una notifica verrà inviata appena la cancellazione sarà conclusa.",
			  showCancelButton: true,
			  confirmButtonColor: "#62cb31",
			  confirmButtonText: "Continua",
			  cancelButtonText: "Annulla",
			  }).then(function() {
				  $.ajax({
					  url: "/w4/scuola24/lib_sql/updrow/calcolabudget.php?w4_sessione=<?php echo $_SESSION['w4_sessione']; ?>",
					  type: 'POST',
					  datatype:'text',
					  data: {
						  id_filtro_calcola: "N",
						  id_filtro_anno: document.getElementById("id_filtro_anno").value,
						  id_filtro_c_iniziativa: document.getElementById("id_filtro_c_iniziativa").value,
						  id_filtro_categoria: document.getElementById("id_filtro_categoria").value,
						  id_filtro_gruppo: document.getElementById("id_filtro_gruppo").value,

						  w4_output_session: JSON.stringify(<?php echo json_encode(session_encode(), JSON_HEX_QUOT | JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_FORCE_OBJECT | JSON_UNESCAPED_UNICODE | JSON_PARTIAL_OUTPUT_ON_ERROR); ?>),
						  w4_mysql_limit_new: document.getElementById("id_mysql_limit").value
					  },
					  success: function(data) {
						  text = data;
						  w4_index_notifiche();
						  return true;
					  }
				  });

		  }, function (dismiss) {});
	  });

	  
		
		
	});


	//**************************************
	// Funzioni chiamate specifiche
	//**************************************

	// Visualizzazione filtro
	function w4_budget_elenco() {

		elenco_budget=[];
		tabella_elenco.fnClearTable();
		
		$.ajax({
			url: "/w4/scuola24/lib_sql/getelenco/getelencobudget.php?w4_sessione=<?php echo $_SESSION['w4_sessione']; ?>",
			type: 'POST',
			data : {
				id_filtro_anno:  document.getElementById("id_filtro_anno").value,
				id_filtro_c_iniziativa:  document.getElementById("id_filtro_c_iniziativa").value,
				id_filtro_categoria:  document.getElementById("id_filtro_categoria").value,
				id_filtro_gruppo:  document.getElementById("id_filtro_gruppo").value
			},
			datatype:'text',
			beforeSend: function() {
				spinnerStart();
			},
			success: function(data) {
			
				text = data;
				
				text = text.replace(new RegExp('\r?\n','g'), '');
		
				if (text.startsWith("Errore:")) {
					flag_spinner = true;
					spinnerStop();
					toastr["warning"]("Con questo filtro non ho trovato nulla.");
					return false;
				}
				elenco_budget = JSON.parse(text);
				tabella_elenco.fnClearTable();
				
				for ( indice in elenco_budget ) {
					tabella_elenco.fnAddData(elenco_budget[indice],false);
				}
				tabella_elenco.fnDraw();
				
				flag_spinner = true;
				spinnerStop();
				
				return true;
		   
			}
		});
		
		


		return true;
	}



	function w4_updbudget_prev () {
		
		
		var datastring = new FormData();
		
		jsonstring = JSON.stringify(elenco_budget);
		datastring.append('id_budget_json', jsonstring);

		xmlhttp = new XMLHttpRequest();
		xmlhttp.open("post", "/w4/scuola24/lib_sql/updrow/updbuget_prev.php?w4_sessione=<?php echo $_SESSION['w4_sessione']; ?>", false);
		xmlhttp.send(datastring);
		var text = xmlhttp.responseText;
		
		if (text.startsWith("Errore:")) {
			return false;
		}
		if (text.startsWith("Attenzione!")) {
			w4_messaggio_errore = text;
			return false;
		}
		
		
		return true;
	}



	function w4_combo_anno() {
		
		var combo_array = [];
		
		id=0;
		for (i = 2000; i < 2051; i++, id++) {
			var elemento = {id:i,
				text:i
				
			};
			combo_array[id] = elemento;
		}
		
		return combo_array;
	}

	function w4_combo_categoria_prod() {
		
		xmlhttp = new XMLHttpRequest();
		
		// campi e valore che passo come se fossero una form
		var data = new FormData();
		
		
		xmlhttp.open("post", "/w4/scuola24/lib_sql/combo/combo_categoria_prod.php?w4_sessione=<?php echo $_SESSION['w4_sessione']; ?>", false);
		xmlhttp.send(data);
		var text = xmlhttp.responseText;
		
		var combo_array = [''];
		if (text.startsWith("Errore:")) {
			return combo_array;
		}
		
		combo_rows = JSON.parse(text);
		
		id=0;
		for (i = 0; i < combo_rows.length; i++, id++) {
			var elemento = {id:combo_rows[i].c_categoria,
				text:combo_rows[i].descrizione};
			combo_array[id] = elemento;
		}
		
		return combo_array;
	}

	function w4_combo_gruppo_prod() {
		
		xmlhttp = new XMLHttpRequest();
		
		// campi e valore che passo come se fossero una form
		var data = new FormData();
		
		data.append('id_c_prod_categoria', document.getElementById("id_filtro_categoria").value);

		xmlhttp.open("post", "/w4/scuola24/lib_sql/combo/combo_gruppo_prod.php?w4_sessione=<?php echo $_SESSION['w4_sessione']; ?>", false);
		xmlhttp.send(data);
		var text = xmlhttp.responseText;
		
		var combo_array = [''];
		if (text.startsWith("Errore:")) {
			return combo_array;
		}
		
		combo_rows = JSON.parse(text);
		
		id=0;
		for (i = 0; i < combo_rows.length; i++, id++) {
			var elemento = {id:combo_rows[i].c_prod_gruppo,
				text:combo_rows[i].descrizione};
			combo_array[id] = elemento;
		}
		
		return combo_array;
	}



	function w4_eventi_tabella () {
		
		$(".id_prev_listino").on("change", function () {
								 
			id_prev_listino = this.id
			elenco_indice = id_prev_listino.replace("id_prev_listino_", "");
			elenco_indice = parseInt(elenco_indice);
			
			
			elenco_budget[elenco_indice].prev_listino = parseFloat(document.getElementById(id_prev_listino).value).wsFixed("2");
			
			elenco_budget[elenco_indice].prev_modificato = "1";
			
			
			if (parseFloat(elenco_budget[elenco_indice].prev_listino) > 0 && parseFloat(elenco_budget[elenco_indice].prev_numero_iscritti) > 0) {
			
				tot_prev_ricavi = parseFloat( parseFloat(elenco_budget[elenco_indice].prev_listino) * parseFloat(elenco_budget[elenco_indice].prev_numero_iscritti)).wsFixed("2");
				
				if (parseFloat(elenco_budget[elenco_indice].prev_perc_sconto_medio) > 0) {
				
					sconto =  parseFloat(parseFloat(tot_prev_ricavi) / 100 * parseFloat(elenco_budget[elenco_indice].prev_perc_sconto_medio)).wsFixed("2");
					tot_prev_ricavi = parseFloat(tot_prev_ricavi - sconto).wsFixed("2");
				
				}
				elenco_budget[elenco_indice].prev_ricavi = tot_prev_ricavi;
				
				// ricalcolo previsionale
				tot_comp_previsionale = parseFloat( (parseFloat(tot_prev_ricavi) / parseFloat(elenco_budget[elenco_indice].mesi_totali)) * parseFloat(elenco_budget[elenco_indice].mesi_anno)).wsFixed("2");
			    elenco_budget[elenco_indice].comp_previsionale = tot_comp_previsionale;
				
				tabella_elenco.fnUpdate (elenco_budget[elenco_indice],elenco_indice,undefined,false,false);
				tabella_elenco.fnDraw(false);
				
			}
			
		});


		$(".id_prev_perc_sconto_medio").on("change", function () {
			
			id_prev_perc_sconto_medio = this.id
			elenco_indice = id_prev_perc_sconto_medio.replace("id_prev_perc_sconto_medio_", "");
			elenco_indice = parseInt(elenco_indice);
			
			
			elenco_budget[elenco_indice].prev_perc_sconto_medio = parseFloat(document.getElementById(id_prev_perc_sconto_medio).value).wsFixed("2");
			
			elenco_budget[elenco_indice].prev_modificato = "1";
			
			
			if (parseFloat(elenco_budget[elenco_indice].prev_listino) > 0 && parseFloat(elenco_budget[elenco_indice].prev_numero_iscritti) > 0) {
			
				tot_prev_ricavi = parseFloat( parseFloat(elenco_budget[elenco_indice].prev_listino) * parseFloat(elenco_budget[elenco_indice].prev_numero_iscritti)).wsFixed("2");
				
				if (parseFloat(elenco_budget[elenco_indice].prev_perc_sconto_medio) > 0) {
				
					sconto =  parseFloat(parseFloat(tot_prev_ricavi) / 100 * parseFloat(elenco_budget[elenco_indice].prev_perc_sconto_medio)).wsFixed("2");
					tot_prev_ricavi = parseFloat(tot_prev_ricavi - sconto).wsFixed("2");
				
				}
				
				elenco_budget[elenco_indice].prev_ricavi = tot_prev_ricavi;

				// ricalcolo previsionale
				tot_comp_previsionale = parseFloat( (parseFloat(tot_prev_ricavi) / parseFloat(elenco_budget[elenco_indice].mesi_totali)) * parseFloat(elenco_budget[elenco_indice].mesi_anno)).wsFixed("2");
			    elenco_budget[elenco_indice].comp_previsionale = tot_comp_previsionale;
				
				tabella_elenco.fnUpdate (elenco_budget[elenco_indice],elenco_indice,undefined,false,false);
				tabella_elenco.fnDraw(false);
				
			}
			
		});



		$(".id_prev_numero_iscritti").on("change", function () {
			
			id_prev_numero_iscritti = this.id
			elenco_indice = id_prev_numero_iscritti.replace("id_prev_numero_iscritti_", "");
			elenco_indice = parseInt(elenco_indice);
			
			
			elenco_budget[elenco_indice].prev_numero_iscritti = parseFloat(document.getElementById(id_prev_numero_iscritti).value).wsFixed("2");
			
			elenco_budget[elenco_indice].prev_modificato = "1";
			
			
			if (parseFloat(elenco_budget[elenco_indice].prev_listino) > 0 && parseFloat(elenco_budget[elenco_indice].prev_numero_iscritti) > 0) {
			
				tot_prev_ricavi = parseFloat( parseFloat(elenco_budget[elenco_indice].prev_listino) * parseFloat(elenco_budget[elenco_indice].prev_numero_iscritti)).wsFixed("2");
				
				if (parseFloat(elenco_budget[elenco_indice].prev_perc_sconto_medio) > 0) {
				
					sconto =  parseFloat(parseFloat(tot_prev_ricavi) / 100 * parseFloat(elenco_budget[elenco_indice].prev_perc_sconto_medio)).wsFixed("2");
					tot_prev_ricavi = parseFloat(tot_prev_ricavi - sconto).wsFixed("2");
				
				}
				
				elenco_budget[elenco_indice].prev_ricavi = tot_prev_ricavi;
				
				// ricalcolo previsionale
				tot_comp_previsionale = parseFloat( (parseFloat(tot_prev_ricavi) / parseFloat(elenco_budget[elenco_indice].mesi_totali)) * parseFloat(elenco_budget[elenco_indice].mesi_anno)).wsFixed("2");
				elenco_budget[elenco_indice].comp_previsionale = tot_comp_previsionale;
				
				tabella_elenco.fnUpdate (elenco_budget[elenco_indice],elenco_indice,undefined,false,false);
				tabella_elenco.fnDraw(false);
				
			}
			
		});
	
	
	}
